/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.view;

import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class UITools {
    private static final long IBEAM_CURSOR = GLFW.glfwCreateStandardCursor((int)221186);
    private static final long HAND_CURSOR = GLFW.glfwCreateStandardCursor((int)221188);
    public static final char CHECK_MARK = '\u2714';
    public static final char BLACK_CIRCLE = '\u25cf';
    private static final Pattern DIGIT_PATTERN = Pattern.compile("[0-9]+");
    private static final Pattern INTEGER_PATTERN = Pattern.compile("^-?[1-9]\\d*$");
    private static final Pattern HEX_PATTERN = Pattern.compile("(?i)[0-9a-f]+");

    public static void useDefaultCursor() {
        GLFW.glfwSetCursor((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (long)0L);
    }

    public static void useIBeamCursor() {
        GLFW.glfwSetCursor((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (long)IBEAM_CURSOR);
    }

    public static void useHandCursor() {
        GLFW.glfwSetCursor((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (long)HAND_CURSOR);
    }

    public static void runViewTraversal(@Nonnull View view, @Nonnull Consumer<View> consumer) {
        consumer.accept(view);
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                UITools.runViewTraversal(group.getChildAt(i), consumer);
            }
        }
    }

    public static boolean matchDigit(String str) {
        return DIGIT_PATTERN.matcher(str).matches();
    }

    public static boolean matchInteger(String str) {
        return INTEGER_PATTERN.matcher(str).matches();
    }

    public static boolean matchHex(String str) {
        return HEX_PATTERN.matcher(str).matches();
    }

    @Nonnull
    public static String[] splitByCaps(@Nonnull String str) {
        return str.split("(?<!^)(?=[A-Z])");
    }

    @Nonnull
    public static String percentageToString(double p) {
        return (int)(p * 100.0) + "%";
    }
}

